<?php

namespace Rtb_objects;

use Helper\utils;
use Helper\validate;

/**
 * Video_object class
 *
 * This class saves the Video objects set by the user before sending the request.
 *
 */
class Video_object {
    /*
     * 
     * name: unknown
     * @param
     * @return
     * 
     */

    public function save($imp_pk_id, $request, $time_stamp) {


        $aConf = $GLOBALS['_MAX']['CONF'];
        //!!!Important not to be changed
        $insert_array = array('imp_pk_id' => "$imp_pk_id");

        if ($imp_pk_id AND $request AND $time_stamp) {
            $object = $this->video_object();
            #Get original name and alias name
            $video_object = $this->format_video_object($object);
            $tmp_prepared_request = array_intersect_key($request, $video_object);

            foreach ($tmp_prepared_request as $key => $data)
                $prepared_request[$video_object[$key]['name']] = $data;

            if (isset($prepared_request)) {
                foreach ($prepared_request as $key => $data) {
                    if (is_array($data)) {
                        $formated = implode(",", array_values($data));
                        $json_converted = json_encode($formated);
                    } else {
                        $json_converted = json_encode($data);
                    }
                    $insert_array[$key] = $json_converted;
                }
            }

            //Create a database connection
            $columns = implode(",", array_keys($insert_array));
            $escaped_values = array_values($insert_array);
            $values = implode(",", $escaped_values);
            $video_pk_id = base64_encode(rand());
            //Close the database connection
            if ($video_pk_id) {
                $log_msg = "    [Initandlisten]  Video object intialized";
                debug_rtb($log_msg, PEAR_LOG_INFO);
                return $video_pk_id;
            } else
                return false;
        }
    }

    /*
     * 
     * name: unknown
     * @param
     * @return
     * 
     */

    public function video_object() {
        //impression object
        //Video Object
        $video_object = array(
            'video_width' => array('name' => 'w', 'type' => '_integer', 'scope' => 'recommended', 'object' => 'Video_Object'),
            'video_height' => array('name' => 'h', 'type' => '_integer', 'scope' => 'recommended', 'object' => 'Video_Object'),
            'linearity' => array('name' => 'linearity', 'type' => '_integer', 'scope' => 'recommended', 'object' => 'Video_Object'),
            'protocols' => array('name' => 'protocols', 'type' => '_integer', 'scope' => 'recommended', 'object' => 'Video_Object'),
            'startdelay' => array('name' => 'startdelay', 'type' => '_integer', 'scope' => 'recommended', 'object' => 'Video_Object'),
            'minduration' => array('name' => 'minduration', 'type' => '_integer', 'scope' => 'recommended', 'object' => 'Video_Object'),
            'maxduration' => array('name' => 'maxduration', 'type' => '_integer', 'scope' => 'recommended', 'object' => 'Video_Object'),
            'mimes' => array('name' => 'mimes', 'type' => '_array_of_string', 'scope' => 'recommended', 'object' => 'Video_Object'),
            'maxextended' => array('name' => 'maxextended', 'type' => '_integer', 'scope' => 'optional', 'object' => 'Video_Object'),
            'pos' => array('name' => 'pos', 'type' => '_integer', 'scope' => 'optional', 'object' => 'Video_Object'),
            'playbackmethod' => array('name' => 'playbackmethod', 'type' => '_array_of_integer', 'scope' => 'optional', 'object' => 'Video_Object'),
           'delivery' => array('name' => 'delivery', 'type' => '_array_of_string', 'scope' => 'optional', 'object' => 'Video_Object'),
            'minbitrate' => array('name' => 'minbitrate', 'type' => '_integer', 'scope' => 'optional', 'object' => 'Video_Object'),
            'maxbitrate' => array('name' => 'maxbitrate', 'type' => '_integer', 'scope' => 'optional', 'object' => 'Video_Object'),
            'boxingallowed' => array('name' => 'boxingallowed', 'type' => '_integer', 'scope' => 'optional', 'object' => 'Video_Object'),
            'skip' => array('name' => 'skip', 'type' => '_integer', 'scope' => 'optional', 'object' => 'Video_Object'),
            'skipafter' => array('name' => 'skipafter', 'type' => '_integer', 'scope' => 'optional', 'object' => 'Video_Object'),
            'companiontype' => array('name' => 'companiontype', 'type' => '_array_of_string', 'scope' => 'optional', 'object' => 'Video_Object'),
             'companionad' => array('name' => 'companionad', 'type' => '_array_of_string', 'scope' => 'optional', 'object' => 'Video_Object')
		
        );

        return $video_object;
    }

    /*
     * 
     * name: unknown
     * @param
     * @return
     * 
     */

    public function format_video_object($object) {
        if ($object) {
            $video_object = array();
            foreach ($object as $key => $data)
                $video_object[$key] = $data;
            return $video_object;
        }
    }

    /*
     * 
     * name: unknown
     * @param
     * @return
     * 
     */

    public function fetch($object) {
        $ob = array();
        if ($object) {
            $video_object = $this->video_object();
            $tmp = array_intersect_key($object, $video_object);
            #Replace with original params
        foreach ($tmp as $key => $data)
	{
		if($key=='companionad')
		{
			if($GLOBALS['_MAX']['RTB_Parameter']['vid_compad']==1)
			{
				 $ob['video'][$video_object[$key]['name']] = array('pos'=>(int)1,'w'=>(int)$GLOBALS['_MAX']['RTB_Parameter']['vid_comp_width'],'h'=>(int)$GLOBALS['_MAX']['RTB_Parameter']['vid_comp_height']);
			}
		}
		else
		{
                $ob['video'][$video_object[$key]['name']] = $data;#this is default,do not change the key.
		}
	}
            if ($ob)
                return json_encode($ob);
            else
                return false;
        }
    }

}

/* End of file Video_object.php */
